package jcircus.tests;

import jcircus.JCircus;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * Class for tests with JUnit.
 *
 * @author  Angela Freitas
 */
public class TestJCircus extends TestCase {

    private String dirExamples = "D:\\Angela\\Research\\Java\\JCircus\\src\\examples\\";
    private String projectDir = "D:\\Angela\\Research\\Java\\Translator";
    private String projectName = "project2";
    
    public TestJCircus(String s) {
        super(s);
    }
    
    static public Test suite() {
        TestSuite suite = new TestSuite(TestJCircus.class);
        return suite;
    }

    public void test_Act() throws Exception {
        (new JCircus()).jCircusMain(dirExamples + "T_Act.tex", projectName, projectDir);
    }
    public void test_ActionParEx() throws Exception {
        (new JCircus()).jCircusMain(dirExamples + "T_ActionParEx.tex", projectName, projectDir);
    }
    public void test_AxDef() throws Exception {
        (new JCircus()).jCircusMain(dirExamples + "T_AxDef.tex", projectName, projectDir);
    }
    public void test_Chronometer() throws Exception {
        (new JCircus()).jCircusMain(dirExamples + "T_Chronometer.tex", projectName, projectDir);
    }
/*    public void test_Err() throws Exception {
        (new JCircus()).jCircusMain(dirExamples + "T_Err.tex", projectName, projectDir);
    }  */
    public void test_Ex1() throws Exception {
        (new JCircus()).jCircusMain(dirExamples + "T_Ex1.tex", projectName, projectDir);
    }
    public void test_ExtMultiSingle() throws Exception {
        (new JCircus()).jCircusMain(dirExamples + "T_ExtMultiSingle.tex", projectName, projectDir);
    }
    /* ChanUseUnificationException: reset */
    public void test_FCS() throws Exception {
        (new JCircus()).jCircusMain(dirExamples + "T_FCS.tex", projectName, projectDir);
    }
    public void test_Fibonacci() throws Exception {
        (new JCircus()).jCircusMain(dirExamples + "T_Fibonacci.tex", projectName, projectDir);
    }
    public void test_GenChannel() throws Exception {
        (new JCircus()).jCircusMain(dirExamples + "T_GenChannel.tex", projectName, projectDir);
    }
    public void test_Guarded() throws Exception {
        (new JCircus()).jCircusMain(dirExamples + "T_Guarded.tex", projectName, projectDir);
    }
    public void test_LocalEnv() throws Exception {
        (new JCircus()).jCircusMain(dirExamples + "T_LocalEnv.tex", projectName, projectDir);
    }
    public void test_Ms() throws Exception {
        (new JCircus()).jCircusMain(dirExamples + "T_MS.tex", projectName, projectDir);
    }
    public void test_MS2() throws Exception {
        (new JCircus()).jCircusMain(dirExamples + "T_MS2.tex", projectName, projectDir);
    }
    public void test_MS3() throws Exception {
        (new JCircus()).jCircusMain(dirExamples + "T_MS3.tex", projectName, projectDir);
    }
    public void testMSExtChoice() throws Exception {
        (new JCircus()).jCircusMain(dirExamples + "T_MSExtChoice.tex", projectName, projectDir);
    }
    public void testMSExtChoice2() throws Exception {
        (new JCircus()).jCircusMain(dirExamples + "T_MSExtChoice2.tex", projectName, projectDir);
    }
    public void test_NameReuse() throws Exception {
        (new JCircus()).jCircusMain(dirExamples + "T_NameReuse.tex", projectName, projectDir);
    }   
    /* Contains parallelism of actions, calls merge with parallel=false for basic process */
    public void test_ParActionsComm() throws Exception {
        (new JCircus()).jCircusMain(dirExamples + "T_ParActionsComm.tex", projectName, projectDir);
    }
    public void test_Proc() throws Exception {
        (new JCircus()).jCircusMain(dirExamples + "T_Proc.tex", projectName, projectDir);
    }
    public void test_SelfParallel() throws Exception {
        (new JCircus()).jCircusMain(dirExamples + "T_SelfParallel.tex", projectName, projectDir);
    }
    public void test_SelfParallel2() throws Exception {
        (new JCircus()).jCircusMain(dirExamples + "T_SelfParallel2.tex", projectName, projectDir);
    }
    public void test_SomeParamProc() throws Exception {
        (new JCircus()).jCircusMain(dirExamples + "T_SomeParamProc.tex", projectName, projectDir);
    }
    public void test_SyncOnMultiple() throws Exception {
        (new JCircus()).jCircusMain(dirExamples + "T_SyncOnMultiple.tex", projectName, projectDir);
    }
    public void test_Tuna() throws Exception {
        (new JCircus()).jCircusMain(dirExamples + "T_Tuna.tex", projectName, projectDir);
    }

    
    public static void main(String[] sa) {
        junit.swingui.TestRunner.run(TestJCircus.class); 
    }
    
}
